/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.export;

import filenet.vw.api.IVWtoXML;
import filenet.vw.api.VWXMLConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.admin.VWConfigRegionNode;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWAccessibilityHelper;
import filenet.vw.toolkit.utils.VWFileFilter;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWKeyAdapter;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class VWExportDialog
extends VWModalDialog
implements ActionListener,
DocumentListener {
    public static final int STATUS_OK = 0;
    public static final int STATUS_CANCEL = 1;
    private Frame m_parentFrame = null;
    private VWConfigRegionNode m_exportRegionNode = null;
    private JTextArea m_instructionsArea = null;
    private JTextField m_filePathTextField = new JTextField();
    private JLabel m_regionLabel = new JLabel();
    private JButton m_cancelButton = null;
    private JButton m_helpButton = null;
    private JButton m_exportButton = null;
    private JButton m_browseButton = null;
    private JCheckBox m_includeSysConfigCheckBox = new JCheckBox(VWResource.IncludeSystemProperties);
    private JCheckBox m_includeUserInfoCheckBox = new JCheckBox(VWResource.IncludeUserInfos);
    private String[] m_exportOutput = null;
    private Font aFont = this.getFont();
    private Font boldFont = new Font(this.aFont.getName(), 1, this.aFont.getSize());

    public VWExportDialog(Frame parent, VWConfigRegionNode rNode) {
        super(parent);
        try {
            this.setTitle(VWIDMBaseFactory.instance().getVWString(4).toString());
            this.m_parentFrame = parent;
            this.m_exportRegionNode = rNode;
            Dimension dim = VWStringUtils.stringToDimension("665,385");
            if (dim == null) {
                dim = new Dimension(600, 350);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.initControls();
            Container mainContainer = this.getContentPane();
            this.m_instructionsArea.setText(VWResource.ExportInstruction1);
            this.m_instructionsArea.setBackground(this.getBackground());
            this.m_instructionsArea.setFont(this.boldFont);
            this.m_instructionsArea.setEditable(false);
            mainContainer.setLayout(new BorderLayout(6, 6));
            mainContainer.add((Component)this.createMainPanel(), "Center");
            mainContainer.add((Component)this.createButtonPanel(), "Last");
            this.setLocationRelativeTo(this.m_parentFrame);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void insertUpdate(DocumentEvent event) {
        this.setExportButtonState();
    }

    public void removeUpdate(DocumentEvent event) {
        this.setExportButtonState();
    }

    public void changedUpdate(DocumentEvent event) {
    }

    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        if (object == this.m_cancelButton) {
            this.setVisible(false);
        } else if (object == this.m_helpButton) {
            VWHelp.displayPage(VWHelp.Help_Process_Config + "bpfc058.htm");
        } else if (object == this.m_exportButton) {
            this.exportItems();
            this.setVisible(false);
        } else if (object == this.m_browseButton) {
            this.showFileDialog();
        }
    }

    public void releaseResources() {
        this.m_parentFrame = null;
        this.m_exportRegionNode = null;
        if (this.m_instructionsArea != null) {
            this.m_instructionsArea.removeAll();
            this.m_instructionsArea = null;
        }
        if (this.m_filePathTextField != null) {
            this.m_filePathTextField.removeAll();
            this.m_filePathTextField = null;
        }
        if (this.m_regionLabel != null) {
            this.m_regionLabel.removeAll();
            this.m_regionLabel = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this);
            this.m_cancelButton.removeAll();
            this.m_cancelButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this);
            this.m_helpButton.removeAll();
            this.m_helpButton = null;
        }
        if (this.m_exportButton != null) {
            this.m_exportButton.removeActionListener(this);
            this.m_exportButton.removeAll();
            this.m_exportButton = null;
        }
        if (this.m_browseButton != null) {
            this.m_browseButton.removeActionListener(this);
            this.m_browseButton.removeAll();
            this.m_browseButton = null;
        }
        if (this.m_includeSysConfigCheckBox != null) {
            this.m_includeSysConfigCheckBox.removeAll();
            this.m_includeSysConfigCheckBox = null;
        }
        if (this.m_includeUserInfoCheckBox != null) {
            this.m_includeUserInfoCheckBox.removeAll();
            this.m_includeUserInfoCheckBox = null;
        }
        this.m_exportOutput = null;
        this.aFont = null;
        this.boldFont = null;
        this.removeAll();
    }

    private void initControls() {
        this.m_instructionsArea = new JTextArea(3, 2);
        this.m_instructionsArea.setText(VWResource.ExportInstruction1);
        this.m_instructionsArea.setEditable(false);
        this.m_instructionsArea.setLineWrap(true);
        this.m_instructionsArea.setWrapStyleWord(true);
        VWAccessibilityHelper.setAccessibility(this.m_instructionsArea, this, VWResource.ExportInstruction1, VWResource.ExportInstruction1);
        this.m_instructionsArea.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_exportButton = new JButton(VWResource.Export);
        this.m_exportButton.setEnabled(false);
        this.m_exportButton.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_exportButton, this, VWResource.Export, VWResource.Export);
        this.m_exportButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_cancelButton = new JButton(VWResource.s_cancel);
        this.m_cancelButton.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_cancelButton, this, VWResource.s_cancel, VWResource.s_cancel);
        this.m_cancelButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_helpButton = new JButton(VWResource.s_help);
        this.m_helpButton.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_helpButton, this, VWResource.s_help, VWResource.s_help);
        this.m_helpButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_browseButton = new JButton(VWResource.s_browse);
        this.m_browseButton.addActionListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_browseButton, this, VWResource.s_browse, VWResource.s_browse);
        this.m_browseButton.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_filePathTextField.getDocument().addDocumentListener(this);
        VWAccessibilityHelper.setAccessibility(this.m_filePathTextField, this, VWResource.ExportFileTextField, VWResource.ExportFileTextFieldDescription);
        this.m_filePathTextField.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_regionLabel.setText(this.m_exportRegionNode.getRegionIDString());
        VWAccessibilityHelper.setAccessibility(this.m_regionLabel, this, VWResource.IsolatedRegion, VWResource.IsolatedRegion);
        this.m_regionLabel.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_includeSysConfigCheckBox.setSelected(false);
        VWAccessibilityHelper.setAccessibility(this.m_includeSysConfigCheckBox, this, VWResource.IncludeSystemProperties, VWResource.IncludeSystemProperties);
        this.m_includeSysConfigCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
        this.m_includeUserInfoCheckBox.setSelected(false);
        VWAccessibilityHelper.setAccessibility(this.m_includeUserInfoCheckBox, this, VWResource.IncludeUserInfos, VWResource.IncludeUserInfos);
        this.m_includeUserInfoCheckBox.addKeyListener(VWKeyAdapter.s_keyAdapter);
    }

    private JPanel createMainPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel();
            GridBagConstraints gbConst = new GridBagConstraints();
            panel.setLayout(new GridBagLayout());
            gbConst.fill = 2;
            gbConst.anchor = 23;
            gbConst.insets = new Insets(10, 10, 10, 10);
            gbConst.gridx = 0;
            gbConst.gridy = 0;
            gbConst.gridheight = 1;
            gbConst.weightx = 1.0;
            gbConst.weighty = 0.0;
            gbConst.gridwidth = 0;
            this.m_instructionsArea.setText(VWResource.ExportInstruction1);
            this.m_instructionsArea.setEditable(false);
            panel.add((Component)this.m_instructionsArea, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            JLabel label = new JLabel(VWResource.s_label.toString(VWResource.IsolatedRegion));
            panel.add((Component)label, gbConst);
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.IsolatedRegion, VWResource.IsolatedRegion);
            label.addKeyListener(VWKeyAdapter.s_keyAdapter);
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            panel.add((Component)this.m_regionLabel, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.gridwidth = 1;
            gbConst.weightx = 0.0;
            label = new JLabel(VWResource.s_label.toString(VWResource.ExportFile));
            VWAccessibilityHelper.setAccessibility(label, this, VWResource.ExportFile, VWResource.ExportFile);
            label.addKeyListener(VWKeyAdapter.s_keyAdapter);
            panel.add((Component)label, gbConst);
            ++gbConst.gridx;
            ++gbConst.gridx;
            gbConst.weightx = 1.0;
            panel.add((Component)this.m_filePathTextField, gbConst);
            ++gbConst.gridx;
            gbConst.weightx = 0.0;
            gbConst.gridwidth = 1;
            panel.add((Component)this.m_browseButton, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            panel.add((Component)this.m_includeSysConfigCheckBox, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.weightx = 1.0;
            gbConst.gridwidth = 0;
            panel.add((Component)this.m_includeUserInfoCheckBox, gbConst);
            gbConst.gridx = 0;
            ++gbConst.gridy;
            gbConst.fill = 1;
            gbConst.weighty = 1.0;
            gbConst.weightx = 1.0;
            panel.add((Component)new JLabel(), gbConst);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private JPanel createFileSelectionPanel() {
        GridBagConstraints gbCons = null;
        JPanel fileSelectionPanel = null;
        try {
            fileSelectionPanel = new JPanel(new GridBagLayout());
            gbCons = new GridBagConstraints();
            gbCons.gridwidth = 1;
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(6, 6, 6, 6);
            fileSelectionPanel.add((Component)new JLabel("Export file:"), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_filePathTextField = new JTextField();
            fileSelectionPanel.add((Component)this.m_filePathTextField, gbCons);
            gbCons.gridwidth = 0;
            ++gbCons.gridx;
            gbCons.weightx = 0.0;
            fileSelectionPanel.add((Component)this.m_browseButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weighty = 1.0;
            fileSelectionPanel.add((Component)new JLabel(), gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return fileSelectionPanel;
    }

    private JPanel createButtonPanel() {
        JPanel panel = null;
        try {
            panel = new JPanel(new FlowLayout());
            panel.add(this.m_exportButton);
            panel.add(this.m_cancelButton);
            panel.add(this.m_helpButton);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return panel;
    }

    private void showFileDialog() {
        FileDialog exportFileDialog = new FileDialog(this.m_parentFrame, VWResource.Export, 1);
        exportFileDialog.setFilenameFilter(new VWFileFilter(".xml"));
        exportFileDialog.setFile(VWResource.ExportFileSaveFilterName);
        exportFileDialog.show();
        String filePath = exportFileDialog.getDirectory();
        String fileName = exportFileDialog.getFile();
        if (filePath != null && fileName != null) {
            this.m_filePathTextField.setText(filePath + fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportItems() {
        try {
            String filePath = this.m_filePathTextField.getText();
            this.setCursor(Cursor.getPredefinedCursor(3));
            IVWtoXML[] apiObjects = this.m_exportRegionNode.getIVWtoXMLItems(this.m_includeSysConfigCheckBox.isSelected(), this.m_includeUserInfoCheckBox.isSelected());
            VWXMLConfiguration.exportConfigurationToFile(apiObjects, filePath);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.m_parentFrame, ex.getLocalizedMessage(), VWResource.ErrorMessage, 0);
            VWDebug.logException(ex);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void setExportButtonState() {
        String tempString;
        if (this.m_exportButton == null) {
            return;
        }
        boolean bEnable = false;
        if (this.m_filePathTextField != null && (tempString = this.m_filePathTextField.getText()) != null) {
            tempString.trim();
            if (tempString.length() > 0) {
                bEnable = true;
            }
        }
        if (this.m_exportButton.isEnabled() != bEnable) {
            this.m_exportButton.setEnabled(bEnable);
        }
    }
}

